      DOUBLE PRECISION X(21), F(21), D(21), WK(42), FE(101), 
     *XE(101), FD(101), R, RP, U, ERROR, ERRORD, A, B, Q, DPCHQA,
     *XANS(4), FANS(4), ERANS(4), EDANS(4), QANS
      LOGICAL SPLINE
      DATA XANS/-0.3D-01,-0.2D-01,-0.1D-01,0.0D0/
      DATA FANS/0.971920D0,0.986880D0,0.996560D0,1.0D0/
      DATA ERANS/-0.6075110024D-02,-0.3219009901D-02,
     *-0.946234414D-03,0.0D0/
      DATA EDANS/0.2932883472D0,0.2677039506D0,0.1744906562D0,0.0D0/
      DATA QANS,IANS/0.274679262701527D0,0/
C
C Arithmetic statement functions for Runge's function and derivative.
C
      R(U)  = 1.0D0/(1.0D0+25.0D0*U*U)
      RP(U) = -50.0D0*U*R(U)**2
C
C Compute Runge's function at 21 points in [-1,1].
C
      DO 1 I=1,21
          X(I) = -1.0D0 + (I-1.0D0)/10.0D0
          F(I) = R(X(I))
    1 CONTINUE
      N = 21
      NWK = 42 
      SPLINE = .FALSE.
C
C Compute cubic Hermite interpolant because SPLINE is .FALSE.
C
      CALL DPCHEZ (N,X,F,D,SPLINE,WK,NWK,IERR)
      IF (IERR .LT. 0) THEN
          WRITE (*,*) 'AN ERROR CALLING DPCHEZ, IERR= ',IERR
          STOP
      ENDIF
C
      NE = 101
C
C Evaluate interpolant and derivative at 101 points from -1 to 0.
C
      DO 2 I=1,NE
          XE(I) = -1.0D0 + (I-1.0D0)/(NE-1.0D0)
    2 CONTINUE
      CALL DPCHEV (N,X,F,D,NE,XE,FE,FD,IERR)
      IF (IERR .NE. 0) THEN
          WRITE (*,*) 'AN ERROR CALLING DPCHEV, IERR= ',IERR
          STOP
      ENDIF
C
      DO 4 I=1,NE
          ERROR = FE(I) - R(XE(I))
          ERRORD = FD(I) - RP(XE(I))
          WRITE (*,3) XE(I),FE(I),ERROR,ERRORD
    3     FORMAT(1X,D17.10,3X,D17.10,3X,D17.10,3X,D17.10)
    4 CONTINUE
C
C Compute integral over the interval [0,1] 
C
      A = 0.0D0
      B = 1.0D0
      Q = DPCHQA (N,X,F,D,A,B,IERR)
      WRITE (*,'(2X,A,D20.12,3X,A,I5)') 'INTEGRAL FROM 0 TO 1 = ',
     *Q,' IERR = ',IERR
C
      WRITE (*,*) 
      WRITE (*,*) 
     *   ' REFERENCE RESULTS FROM IBM PC/AT OF PRECEDING 5 LINES '
      DO 6 I=1,4
          WRITE (*,5) XANS(I),FANS(I),ERANS(I),EDANS(I)
    5     FORMAT(1X,D17.10,3X,D17.10,3X,D17.10,3X,D17.10)
    6 CONTINUE
      WRITE (*,'(2X,A,D20.12,3X,A,I5)') 'INTEGRAL FROM 0 TO 1 = ',
     *QANS,' IERR = ',IANS           
      STOP
      END
